/*!
 * # Semantic UI 2.2.11 - Checkbox
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,n,i,t){"use strict";n=void 0!==n&&n.Math==Math?n:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),e.fn.checkbox=function(t){var o,a=e(this),c=a.selector||"",r=(new Date).getTime(),d=[],l=arguments[0],s="string"==typeof l,u=[].slice.call(arguments,1);return a.each(function(){var a,b,h=e.extend(!0,{},e.fn.checkbox.settings,t),g=h.className,f=h.namespace,p=h.selector,k=h.error,m="."+f,v="module-"+f,y=e(this),C=e(this).children(p.label),x=e(this).children(p.input),w=x[0],I=!1,D=!1,S=y.data(v),E=this;b={initialize:function(){b.verbose("Initializing checkbox",h),b.create.label(),b.bind.events(),b.set.tabbable(),b.hide.input(),b.observeChanges(),b.instantiate(),b.setup()},instantiate:function(){b.verbose("Storing instance of module",b),S=b,y.data(v,b)},destroy:function(){b.verbose("Destroying module"),b.unbind.events(),b.show.input(),y.removeData(v)},fix:{reference:function(){y.is(p.input)&&(b.debug("Behavior called on <input> adjusting invoked element"),y=y.closest(p.checkbox),b.refresh())}},setup:function(){b.set.initialLoad(),b.is.indeterminate()?(b.debug("Initial value is indeterminate"),b.indeterminate()):b.is.checked()?(b.debug("Initial value is checked"),b.check()):(b.debug("Initial value is unchecked"),b.uncheck()),b.remove.initialLoad()},refresh:function(){C=y.children(p.label),x=y.children(p.input),w=x[0]},hide:{input:function(){b.verbose("Modifying <input> z-index to be unselectable"),x.addClass(g.hidden)}},show:{input:function(){b.verbose("Modifying <input> z-index to be selectable"),x.removeClass(g.hidden)}},observeChanges:function(){"MutationObserver"in n&&(a=new MutationObserver(function(e){b.debug("DOM tree modified, updating selector cache"),b.refresh()}),a.observe(E,{childList:!0,subtree:!0}),b.debug("Setting up mutation observer",a))},attachEvents:function(n,i){var t=e(n);i=e.isFunction(b[i])?b[i]:b.toggle,t.length>0?(b.debug("Attaching checkbox events to element",n,i),t.on("click"+m,i)):b.error(k.notFound)},event:{click:function(n){var i=e(n.target);return i.is(p.input)?void b.verbose("Using default check action on initialized checkbox"):i.is(p.link)?void b.debug("Clicking link inside checkbox, skipping toggle"):(b.toggle(),x.focus(),void n.preventDefault())},keydown:function(e){var n=e.which,i={enter:13,space:32,escape:27};n==i.escape?(b.verbose("Escape key pressed blurring field"),x.blur(),D=!0):e.ctrlKey||n!=i.space&&n!=i.enter?D=!1:(b.verbose("Enter/space key pressed, toggling checkbox"),b.toggle(),D=!0)},keyup:function(e){D&&e.preventDefault()}},check:function(){b.should.allowCheck()&&(b.debug("Checking checkbox",x),b.set.checked(),b.should.ignoreCallbacks()||(h.onChecked.call(w),h.onChange.call(w)))},uncheck:function(){b.should.allowUncheck()&&(b.debug("Unchecking checkbox"),b.set.unchecked(),b.should.ignoreCallbacks()||(h.onUnchecked.call(w),h.onChange.call(w)))},indeterminate:function(){if(b.should.allowIndeterminate())return void b.debug("Checkbox is already indeterminate");b.debug("Making checkbox indeterminate"),b.set.indeterminate(),b.should.ignoreCallbacks()||(h.onIndeterminate.call(w),h.onChange.call(w))},determinate:function(){if(b.should.allowDeterminate())return void b.debug("Checkbox is already determinate");b.debug("Making checkbox determinate"),b.set.determinate(),b.should.ignoreCallbacks()||(h.onDeterminate.call(w),h.onChange.call(w))},enable:function(){if(b.is.enabled())return void b.debug("Checkbox is already enabled");b.debug("Enabling checkbox"),b.set.enabled(),h.onEnable.call(w),h.onEnabled.call(w)},disable:function(){if(b.is.disabled())return void b.debug("Checkbox is already disabled");b.debug("Disabling checkbox"),b.set.disabled(),h.onDisable.call(w),h.onDisabled.call(w)},get:{radios:function(){var n=b.get.name();return e('input[name="'+n+'"]').closest(p.checkbox)},otherRadios:function(){return b.get.radios().not(y)},name:function(){return x.attr("name")}},is:{initialLoad:function(){return I},radio:function(){return x.hasClass(g.radio)||"radio"==x.attr("type")},indeterminate:function(){return void 0!==x.prop("indeterminate")&&x.prop("indeterminate")},checked:function(){return void 0!==x.prop("checked")&&x.prop("checked")},disabled:function(){return void 0!==x.prop("disabled")&&x.prop("disabled")},enabled:function(){return!b.is.disabled()},determinate:function(){return!b.is.indeterminate()},unchecked:function(){return!b.is.checked()}},should:{allowCheck:function(){return b.is.determinate()&&b.is.checked()&&!b.should.forceCallbacks()?(b.debug("Should not allow check, checkbox is already checked"),!1):!1!==h.beforeChecked.apply(w)||(b.debug("Should not allow check, beforeChecked cancelled"),!1)},allowUncheck:function(){return b.is.determinate()&&b.is.unchecked()&&!b.should.forceCallbacks()?(b.debug("Should not allow uncheck, checkbox is already unchecked"),!1):!1!==h.beforeUnchecked.apply(w)||(b.debug("Should not allow uncheck, beforeUnchecked cancelled"),!1)},allowIndeterminate:function(){return b.is.indeterminate()&&!b.should.forceCallbacks()?(b.debug("Should not allow indeterminate, checkbox is already indeterminate"),!1):!1!==h.beforeIndeterminate.apply(w)||(b.debug("Should not allow indeterminate, beforeIndeterminate cancelled"),!1)},allowDeterminate:function(){return b.is.determinate()&&!b.should.forceCallbacks()?(b.debug("Should not allow determinate, checkbox is already determinate"),!1):!1!==h.beforeDeterminate.apply(w)||(b.debug("Should not allow determinate, beforeDeterminate cancelled"),!1)},forceCallbacks:function(){return b.is.initialLoad()&&h.fireOnInit},ignoreCallbacks:function(){return I&&!h.fireOnInit}},can:{change:function(){return!(y.hasClass(g.disabled)||y.hasClass(g.readOnly)||x.prop("disabled")||x.prop("readonly"))},uncheck:function(){return"boolean"==typeof h.uncheckable?h.uncheckable:!b.is.radio()}},set:{initialLoad:function(){I=!0},checked:function(){if(b.verbose("Setting class to checked"),y.removeClass(g.indeterminate).addClass(g.checked),b.is.radio()&&b.uncheckOthers(),!b.is.indeterminate()&&b.is.checked())return void b.debug("Input is already checked, skipping input property change");b.verbose("Setting state to checked",w),x.prop("indeterminate",!1).prop("checked",!0),b.trigger.change()},unchecked:function(){if(b.verbose("Removing checked class"),y.removeClass(g.indeterminate).removeClass(g.checked),!b.is.indeterminate()&&b.is.unchecked())return void b.debug("Input is already unchecked");b.debug("Setting state to unchecked"),x.prop("indeterminate",!1).prop("checked",!1),b.trigger.change()},indeterminate:function(){if(b.verbose("Setting class to indeterminate"),y.addClass(g.indeterminate),b.is.indeterminate())return void b.debug("Input is already indeterminate, skipping input property change");b.debug("Setting state to indeterminate"),x.prop("indeterminate",!0),b.trigger.change()},determinate:function(){if(b.verbose("Removing indeterminate class"),y.removeClass(g.indeterminate),b.is.determinate())return void b.debug("Input is already determinate, skipping input property change");b.debug("Setting state to determinate"),x.prop("indeterminate",!1)},disabled:function(){if(b.verbose("Setting class to disabled"),y.addClass(g.disabled),b.is.disabled())return void b.debug("Input is already disabled, skipping input property change");b.debug("Setting state to disabled"),x.prop("disabled","disabled"),b.trigger.change()},enabled:function(){if(b.verbose("Removing disabled class"),y.removeClass(g.disabled),b.is.enabled())return void b.debug("Input is already enabled, skipping input property change");b.debug("Setting state to enabled"),x.prop("disabled",!1),b.trigger.change()},tabbable:function(){b.verbose("Adding tabindex to checkbox"),void 0===x.attr("tabindex")&&x.attr("tabindex",0)}},remove:{initialLoad:function(){I=!1}},trigger:{change:function(){var e=i.createEvent("HTMLEvents"),n=x[0];n&&(b.verbose("Triggering native change event"),e.initEvent("change",!0,!1),n.dispatchEvent(e))}},create:{label:function(){x.prevAll(p.label).length>0?(x.prev(p.label).detach().insertAfter(x),b.debug("Moving existing label",C)):b.has.label()||(C=e("<label>").insertAfter(x),b.debug("Creating label",C))}},has:{label:function(){return C.length>0}},bind:{events:function(){b.verbose("Attaching checkbox events"),y.on("click"+m,b.event.click).on("keydown"+m,p.input,b.event.keydown).on("keyup"+m,p.input,b.event.keyup)}},unbind:{events:function(){b.debug("Removing events"),y.off(m)}},uncheckOthers:function(){var e=b.get.otherRadios();b.debug("Unchecking other radios",e),e.removeClass(g.checked)},toggle:function(){if(!b.can.change())return void(b.is.radio()||b.debug("Checkbox is read-only or disabled, ignoring toggle"));b.is.indeterminate()||b.is.unchecked()?(b.debug("Currently unchecked"),b.check()):b.is.checked()&&b.can.uncheck()&&(b.debug("Currently checked"),b.uncheck())},setting:function(n,i){if(b.debug("Changing setting",n,i),e.isPlainObject(n))e.extend(!0,h,n);else{if(void 0===i)return h[n];e.isPlainObject(h[n])?e.extend(!0,h[n],i):h[n]=i}},internal:function(n,i){if(e.isPlainObject(n))e.extend(!0,b,n);else{if(void 0===i)return b[n];b[n]=i}},debug:function(){!h.silent&&h.debug&&(h.performance?b.performance.log(arguments):(b.debug=Function.prototype.bind.call(console.info,console,h.name+":"),b.debug.apply(console,arguments)))},verbose:function(){!h.silent&&h.verbose&&h.debug&&(h.performance?b.performance.log(arguments):(b.verbose=Function.prototype.bind.call(console.info,console,h.name+":"),b.verbose.apply(console,arguments)))},error:function(){h.silent||(b.error=Function.prototype.bind.call(console.error,console,h.name+":"),b.error.apply(console,arguments))},performance:{log:function(e){var n,i,t;h.performance&&(n=(new Date).getTime(),t=r||n,i=n-t,r=n,d.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:E,"Execution Time":i})),clearTimeout(b.performance.timer),b.performance.timer=setTimeout(b.performance.display,500)},display:function(){var n=h.name+":",i=0;r=!1,clearTimeout(b.performance.timer),e.each(d,function(e,n){i+=n["Execution Time"]}),n+=" "+i+"ms",c&&(n+=" '"+c+"'"),(void 0!==console.group||void 0!==console.table)&&d.length>0&&(console.groupCollapsed(n),console.table?console.table(d):e.each(d,function(e,n){console.log(n.Name+": "+n["Execution Time"]+"ms")}),console.groupEnd()),d=[]}},invoke:function(n,i,t){var a,c,r,d=S;return i=i||u,t=E||t,"string"==typeof n&&void 0!==d&&(n=n.split(/[\. ]/),a=n.length-1,e.each(n,function(i,t){var o=i!=a?t+n[i+1].charAt(0).toUpperCase()+n[i+1].slice(1):n;if(e.isPlainObject(d[o])&&i!=a)d=d[o];else{if(void 0!==d[o])return c=d[o],!1;if(!e.isPlainObject(d[t])||i==a)return void 0!==d[t]?(c=d[t],!1):(b.error(k.method,n),!1);d=d[t]}})),e.isFunction(c)?r=c.apply(t,i):void 0!==c&&(r=c),e.isArray(o)?o.push(r):void 0!==o?o=[o,r]:void 0!==r&&(o=r),c}},s?(void 0===S&&b.initialize(),b.invoke(l)):(void 0!==S&&S.invoke("destroy"),b.initialize())}),void 0!==o?o:this},e.fn.checkbox.settings={name:"Checkbox",namespace:"checkbox",silent:!1,debug:!1,verbose:!0,performance:!0,uncheckable:"auto",fireOnInit:!1,onChange:function(){},beforeChecked:function(){},beforeUnchecked:function(){},beforeDeterminate:function(){},beforeIndeterminate:function(){},onChecked:function(){},onUnchecked:function(){},onDeterminate:function(){},onIndeterminate:function(){},onEnable:function(){},onDisable:function(){},onEnabled:function(){},onDisabled:function(){},className:{checked:"checked",indeterminate:"indeterminate",disabled:"disabled",hidden:"hidden",radio:"radio",readOnly:"read-only"},error:{method:"The method you called is not defined"},selector:{checkbox:".ui.checkbox",label:"label, .box",input:'input[type="checkbox"], input[type="radio"]',link:"a[href]"}}}(jQuery,window,document);