<?php
/**
 *------------------------------------------------------------------------------
 *  iCagenda v3 by Jooml!C - Events Management Extension for Joomla! 2.5 / 3.x
 *------------------------------------------------------------------------------
 *
 * @package LiveUpdate 2.1.5 - 2.2.1
 * @copyright Copyright (c)2010-2012 Nicholas K. Dionysopoulos / AkeebaBackup.com
 * @license GNU LGPLv3 or later <http://www.gnu.org/copyleft/lesser.html>
 *
 * @version     3.4.0.1 2014-12-25
 * @since       1.2.6
 *
 * ADDED (3.3.6)			: option for min_stability in getMinimumStability()
 * CHANGED (3.4.0-alpha2)	: option for updateURL in getUpdateURL() (set updateURL depending on getMinimumStability())
 * ADDED (3.4.0-alpha2)		: Own server for Testing Updates (Alpha & Beta)
 * ADDED (3.4.0)			: filter getAuthorization()
 */

defined('_JEXEC') or die();

/**
 * This is the base class inherited by the config.php file in LiveUpdate's root.
 * You may override it non-final members to customise its behaviour.
 * @author Nicholas K. Dionysopoulos <nicholas@akeebabackup.com>
 *
 */
abstract class LiveUpdateAbstractConfig extends JObject
{
	/** @var string The extension name, e.g. com_foobar, plg_foobar, mod_foobar, tpl_foobar etc */
	protected $_extensionName = 'com_icagenda';
	/** @var string The human-readable name of your extension */
	protected $_extensionTitle = 'iCagenda - Events Management Extension for Joomla!';
	/**
	 * The filename of the XML manifest of your extension. Leave blank to use extensionname.xml. For example,
	 * if the extension is com_foobar, it will look for com_foobar.xml and foobar.xml in the component's
	 * directory.
	 * @var string
	 * */
	protected $_xmlFilename = '';

	/** @var string The information storage adapter to use. Can be 'file' or 'component' */
	protected $_storageAdapter = 'file';
	/** @var array The configuration options for the storage adapter used */
	protected $_storageConfig = array('path' => JPATH_CACHE);
	/**
	 * How to determine if a new version is available. 'different' = if the version number is different,
	 * the remote version is newer, 'vcompare' = use version compare between the two versions, 'newest' =
	 * compare the release dates to find the newest. I suggest using 'different' on most cases.
	 * @var string
	 */
	protected $_versionStrategy = 'different';

	/** @var The current version of your extension. Populated automatically from the XML manifest. */
	protected $_currentVersion = '';
	/** @var The current release date of your extension. Populated automatically from the XML manifest. */
	protected $_currentReleaseDate = '';

	/** @var string The URL to the INI update stream of this extension */
	protected $_updateURL = '';
	/** @var bool Does the download URL require authorization to download the package? */
	protected $_requiresAuthorization = false;

	/** @var string The username to authorize a download on your site */
	protected $_username = '';
	/** @var string The password to authorize a download on your site */
	protected $_password = '';
	/** @var string The Download ID to authorize a download on your site; use it instead of the username/password pair */
	protected $_downloadID = '';

	/** @var string The path to a local copy of cacert.pem, required if you plan on using HTTPS URLs to fetch live udpate information or download files from */
	protected $_cacerts = null;

	/** @var string The minimum stability level to report as available update. One of alpha, beta, rc and stable. */
	protected $_minStability = 'stable';

	/**
	 * Singleton implementation
	 * @return LiveUpdateConfig An instance of the Live Update configuration class
	 */
	public static function &getInstance()
	{
		static $instance = null;

		if(!is_object($instance)) {
			$instance = new LiveUpdateConfig();
		}

		return $instance;
	}

	/**
	 * Public constructor. It populates all extension-specific fields. Override to your liking if necessary.
	 */
	public function __construct()
	{
		parent::__construct();
		$this->populateExtensionInfo();
		$this->populateAuthorization();
	}

	/**
	 * Returns the URL to the update INI stream. By default it returns the value to
	 * the protected $_updateURL property of the class. Override with your implementation
	 * if you want to modify its logic.
	 */
	public function getUpdateURL()
	{
		$minStability = self::getMinimumStability();

		switch($minStability) {
			case 'alpha':
			default:
				// Reports any stability level as an available update
				$ic_updateURL = 'http://pro.joomlic.com/index.php?option=com_ars&view=update&format=ini&id=2';
				break;

//			case 'beta':
				// Do not report alphas as available updates
//				if(in_array($stability, array('alpha'))) return 0;
//				break;

			case 'rc':
				// Do not report alphas and betas as available updates
				$ic_updateURL = 'http://pro.joomlic.com/index.php?option=com_ars&view=update&format=ini&id=1';
				break;

			case 'stable':
				// Do not report alphas, betas and rcs as available updates
				$ic_updateURL = 'http://pro.joomlic.com/index.php?option=com_ars&view=update&format=ini&id=1';
				break;
		}


		return $ic_updateURL;
//		return $this->_updateURL;
	}

	/**
	 * Override this ethod to load customized CSS and media files instead of the stock
	 * CSS and media provided by Live Update. If you override this class it MUST return
	 * true, otherwise LiveUpdate's CSS will be loaded after yours and will override your
	 * settings.
	 *
	 * @return bool Return true to stop Live Update from loading its own CSS files.
	 */
	public function addMedia()
	{
		return false;
	}

	/**
	 * Gets the authorization string to append to the download URL. It returns either the
	 * download ID or username/password pair. Please override the class constructor, not
	 * this method, if you want to fetch these values.
	 */
	public final function getAuthorization()
	{
		if (!empty($this->_downloadID))
		{
			return "dlid=".urlencode($this->_downloadID);
		}
		elseif (!empty($this->_username) && !empty($this->_password))
		{
			$_pass = str_replace('/', '.', $this->_password);
			$pass_ex = explode('.', $_pass);

			if (isset($pass_ex[1]))
			{
				$password = base64_decode($pass_ex[1]);
			}
			else
			{
				$password = $this->_password;
			}

			return "username=".urlencode($this->_username)."&password=".urlencode($password);
		}

		return "";
	}

	public final function requiresAuthorization()
	{
		return $this->_requiresAuthorization;
	}

	/**
	 * Returns all the information we have about the extension and its update preferences
	 * @return array The extension information
	 */
	public final function getExtensionInformation()
	{
		return array(
			'name'			=> $this->_extensionName,
			'title'			=> $this->_extensionTitle,
			'version'		=> $this->_currentVersion,
			'date'			=> $this->_currentReleaseDate,
//			'updateurl'		=> $this->_updateURL,
			'updateurl'		=> self::getUpdateURL(),
			'requireauth'	=> $this->_requiresAuthorization
		);
	}

	/**
	 * Returns the information regarding the storage adapter
	 * @return array
	 */
	public final function getStorageAdapterPreferences()
	{
		$config = $this->_storageConfig;
		$config['extensionName'] = $this->_extensionName;

		return array(
			'adapter'		=> $this->_storageAdapter,
			'config'		=> $config
		);
	}

	public final function getVersionStrategy()
	{
		return $this->_versionStrategy;
	}

	/**
	 * Get the current version from the XML manifest of the extension and
	 * populate the class' properties.
	 */
	private function populateExtensionInfo()
	{
		require_once dirname(__FILE__).'/xmlslurp.php';
		$xmlslurp = new LiveUpdateXMLSlurp();
		$data = $xmlslurp->getInfo($this->_extensionName, $this->_xmlFilename);
		if(empty($this->_currentVersion)) $this->_currentVersion = $data['version'];
		if(empty($this->_currentReleaseDate)) $this->_currentReleaseDate = $data['date'];
	}

	/**
	 * Fetch username/password and Download ID from the component's configuration.
	 */
	protected function populateAuthorization()
	{
		if(!$this->_requiresAuthorization) return;

		// Do we already have authorizaton information?
		if( (!empty($this->_username) && !empty($this->_password)) || !empty($this->_downloadID) ) {
			return;
		}

		if(substr($this->_extensionName,0,3) != 'com') return;

		// Not using JComponentHelper to avoid conflicts ;)
		$db = JFactory::getDbo();
		$sql = $db->getQuery(true)
			->select($db->qn('params'))
			->from($db->qn('#__extensions'))
			->where($db->qn('type').' = '.$db->q('component'))
			->where($db->qn('element').' = '.$db->q($this->_extensionName));
		$db->setQuery($sql);
		$rawparams = $db->loadResult();
		$params = new JRegistry();
		$params->loadString($rawparams, 'JSON');

		$this->_username	= $params->get('username','');
		$this->_password	= $params->get('password','');
		$this->_downloadID	= $params->get('downloadid','');
	}

	public function applyCACert(&$ch)
	{
		if(!empty($this->_cacerts)) {
			if(file_exists($this->_cacerts)) {
				@curl_setopt($ch, CURLOPT_CAINFO, $this->_cacerts);
			}
		}
	}

	public function getMinimumStability()
	{
		// Not using JComponentHelper to avoid conflicts ;)
		$db = JFactory::getDbo();
		$sql = $db->getQuery(true)
			->select($db->qn('params'))
			->from($db->qn('#__extensions'))
			->where($db->qn('type').' = '.$db->q('component'))
			->where($db->qn('element').' = '.$db->q('com_icagenda'));
		$db->setQuery($sql);
		$rawparams = $db->loadResult();
		$params = new JRegistry();
		$params->loadString($rawparams, 'JSON');

		$ic_minStability	= $params->get('min_stability','stable');

		return $ic_minStability;
	}
}
