<?php
defined('JPATH_BASE') or die;

include_once('oauth.php');
jimport( 'joomla.html.parameter' );

class JPesapal {
	var $token;
	var $params;
	var $consumer_key; 
	var $consumer_secret;
	var $signature_method;
	var $iframelink;
	var $statusrequest;
	public function __construct(){
		// PHPMailer has an issue using the relative path for it's language files
		$component = JComponentHelper::getComponent( 'com_donation' );
 		$params = new JParameter( $component->params );
		$this->token = $this->params = NULL;
		// PHPMailer has an issue using the relative path for it's language files
		$this->consumer_key 	= $params->get ( 'consumer_key' );
		$this->consumer_secret 	= $params->get ( 'consumer_secret' );
		$this->signature_method = new OAuthSignatureMethod_HMAC_SHA1();
		$this->iframelink 		= $params->get ( 'link_prefix' ).'.pesapal.com/api/PostPesapalDirectOrderV4';
		$this->statusrequest 	= $params->get ( 'link_prefix' ).'.pesapal.com/api/verifyorderbymerchantref';	

	}
	
	public function loadIframe($details=array()){
		if(count($details)){
			$amount = $details['amount'];
			$desc = $details['desc'];
			$code = '';
			$type = 'MERCHANT';
			$payment_method = '';
			$reference = $details['reference'];
			$first_name = $details['first_name'];
			$last_name = $details['last_name'];
			$email = $details['email'];
			$currency = $details['currency'];
			$phonenumber = '';
			$username = $email;
			$callback_url = $details['callback_url'];
			
			$consumer = new OAuthConsumer($this->consumer_key, $this->consumer_secret);
			
			$post_xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>
				<PesapalDirectOrderInfo 
					xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" 
					xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" 
					Currency=\"".$currency."\" 
					Amount=\"".$amount."\" 
					Description=\"".$desc."\" 
					Type=\"".$type."\" 
					Reference=\"".$reference."\" 
					FirstName=\"".$first_name."\" 
					LastName=\"".$last_name."\" 
					Email=\"".$email."\" 
					PhoneNumber=\"".$phonenumber."\" 
					xmlns=\"http://www.pesapal.com\" />";
					
			$post_xml = htmlentities($post_xml);
			
			//post transaction to pesapal
			$iframe_src = OAuthRequest::from_consumer_and_token($consumer, $this->token, "GET", $this->iframelink, $this->params);
			$iframe_src->set_parameter("oauth_callback", $callback_url);
			$iframe_src->set_parameter("pesapal_request_data", $post_xml);
			$iframe_src->sign_request($this->signature_method, $consumer, $this->token);
			
			?>
        <iframe src="<?php echo $iframe_src;?>" width="100%" height="700px"  scrolling="no" frameBorder="0">
            <p>Browser unable to load iFrame</p>
        </iframe>
		<?php

		}
	}

}