<?php
/**
 *----------------------------------------------------------------------------
 * iCagenda     Events Management Extension for Joomla!
 *      PRO     Module iC Event List
 *----------------------------------------------------------------------------
 * @version     3.14.5 2018-04-30
 *
 * @package     iCagendaPro.Site
 * @subpackage  mod_ic_event_list
 * @link        https://icagenda.joomlic.com
 *
 * @author      Cyril Rezé
 * @copyright   (c) 2012-2018 Jooml!C / Cyril Rezé. All rights reserved.
 * @license     GNU General Public License version 3 or later; see LICENSE.txt
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @since       1.0
 *----------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

// Get Component Global Options
$iCparams = JComponentHelper::getParams('com_icagenda');

// For Dev.
$time_loading = $iCparams->get('time_loading', '');

if ($time_loading && class_exists('iCLibrary'))
{
	$starttime_cal = iCLibrary::getMicrotime();
}

// Global Joomla API objects
$app        = JFactory::getApplication();
$document   = JFactory::getDocument();
$lang       = JFactory::getLanguage();

$menu		= $app->getMenu();

// Check Errors: iC Library & iCagenda Utilities
$UTILITIES_DIR = is_dir(JPATH_ADMINISTRATOR . '/components/com_icagenda/utilities');

if ( (!$UTILITIES_DIR)
	|| (!class_exists('iCLibrary')) )
{
	$alert_message = JText::_('ICAGENDA_CAN_NOT_LOAD').'<br />';
	$alert_message.= '<ul>';
	if (!class_exists('iCLibrary')) $alert_message.= '<li>' . JText::_('IC_LIBRARY_NOT_LOADED') . '</li>';
	if (!$UTILITIES_DIR) $alert_message.= '<li>' . JText::_('ICAGENDA_A_FOLDER_IS_MISSING') . '</li>';
	$alert_message.= '</ul>';
	if (!$UTILITIES_DIR) $alert_message.= JText::_('ICAGENDA_IS_NOT_CORRECTLY_INSTALLED') . ' ';
	if (!$UTILITIES_DIR) $alert_message.= JText::_('ICAGENDA_INSTALL_AGAIN') . '<br />';
	if (!$UTILITIES_DIR) $alert_message.= JText::_('IC_ALTERNATIVELY') . ':<br /><ul>';
	if ($UTILITIES_DIR) $alert_message.= JText::_('IC_PLEASE') . ', ';
	if (!class_exists('iCLibrary'))
	{
		if (!$UTILITIES_DIR) $alert_message.= '<li>';
		$alert_message.= JText::_('IC_LIBRARY_CHECK_PLUGIN_AND_LIBRARY');
		if (!$UTILITIES_DIR) $alert_message.= '</li>';
	}
	if (!$UTILITIES_DIR)
	{
		$alert_message.= '<li>' . JText::Sprintf('ICAGENDA_UTILITIES_FIX_MANUAL'
						, '<strong>admin/utilities</strong>'
						, '<strong>administrator/components/com_icagenda/</strong>');
		$alert_message.= '</li></ul>';
	}

	// Get the message queue
	$messages = $app->getMessageQueue();

	$display_alert_message = false;

	// If we have messages
	if (is_array($messages) && count($messages))
	{
		// Check each message for the one we want
		foreach ($messages as $key => $value)
		{
			if ($value['message'] == $alert_message)
			{
				$display_alert_message = true;
			}
		}
	}

	if (!$display_alert_message)
	{
		$app->enqueueMessage($alert_message, 'error');
	}

	echo JText::_('IC_MODULE_CAN_NOT_BE_LOADED') . '<br />';
	echo JText::_('IC_MODULE_CHECK_ALERT_MESSAGE');

	return false;
}

// Load iCagenda Utilities
JLoader::registerPrefix('icagenda', JPATH_ADMINISTRATOR . '/components/com_icagenda/utilities');

// Test if translation is missing, set to en-GB by default
$lang->load( 'mod_ic_event_list', JPATH_SITE, 'en-GB', true );
$lang->load( 'mod_ic_event_list', JPATH_SITE, null, true );

// Static call to the framework module processor which will
// Include the layout file (procedural, not a class)
jimport( 'joomla.application.module.helper' );

// Include the class of the syndicate functions only once
require_once(dirname(__FILE__) . '/helper.php');

// Load iCtip css
JHtml::stylesheet( 'com_icagenda/tipTip.css', false, true );

// Check valid NEXT DATE (removed 3.6.3)
//icagendaEventsData::getNext();

// Load jQuery Files
if (version_compare(JVERSION, '3.0', 'lt'))
{
	JHtml::_('behavior.mootools');

	// load jQuery, if not loaded before (NEW VERSION IN 1.2.6)
	$scripts		= array_keys($document->_scripts);
	$scriptFound	= false;
	$count_scripts	= count($scripts);

	for ($i = 0; $i < $count_scripts; $i++)
	{
		if (stripos($scripts[$i], 'jquery.min.js') !== false)
		{
			$scriptFound = true;
		}

		// load jQuery, if not loaded before as jquery - added in 1.2.7
		if (stripos($scripts[$i], 'jquery.js') !== false)
		{
		    $scriptFound = true;
		}
	}

	// jQuery Library Loader
	if (!$scriptFound)
	{
		// load jQuery, if not loaded before
		if (!JFactory::getApplication()->get('jquery'))
		{
			JFactory::getApplication()->set('jquery', true);
			// add jQuery
			$document->addScript('https://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js');
		    $document->addScript('components/com_icagenda/js/jquery.noconflict.js');
		}
	}
}
else
{
	JHtml::_('bootstrap.framework');
	JHtml::_('jquery.framework');
}

// Loading Script tipTip used for iCtips
JHtml::script( 'com_icagenda/jquery.tipTip.js', false, true );

$iCtip	 = array();
$iCtip[] = '	jQuery(document).ready(function(){';
$iCtip[] = '		jQuery(".iCtip").tipTip({maxWidth: "200", defaultPosition: "top", edgeOffset: 1});';
$iCtip[] = '	});';

// Add the script to the document head.
JFactory::getDocument()->addScriptDeclaration(implode("\n", $iCtip));

// Static call to the class
$list = modiCEventListHelper::getList($params);

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

// Itemid Request (automatic detection of the first iCagenda menu-link, by menuID)
$iC_list_menus	= icagendaMenus::iClistMenuItemsInfo();

/*
 * Module Params
 */
// Link to Menu Item
$iCmenuitem				= $params->get('iCmenuitem');
$iCmenu_filters			= $params->get('iCmenu_filters', 0);

	$orderby				= $params->get('orderby', 2);
	$mcatid					= $params->get('mcatid', 'all');
	$datesDisplay			= ($params->get('datesDisplay') == '0')
							? '2'
							: $params->get('datesDisplay', $iCparams->get('datesDisplay', 2));

	$limitcount				= $params->get('count', 5);
	$monthFormat			= $params->get('monthFormat', 2);

// Display Options
$display_city			= $params->get('dp_city', 1);
$display_dateTime		= $params->get('dp_dateTime', 0);
$display_regInfos		= $params->get('dp_regInfos', 0);
$param_shortDesc		= $params->get('dp_shortDesc', '');
$display_venue			= $params->get('dp_venue', 1);

	$filtering_shortDesc	= $params->get('filtering_shortDesc', '');
	$paramlimit				= $params->get('paramlimit', '');
	$paramlimit_Content		= $params->get('paramlimit_Content');

// Grid Options
$column					= $params->get('column', 'col1');

// Header & Footer Options
$header_text			= $params->get('header_text', '');
$footer_text			= $params->get('footer_text', '');

	// Feature Icons Options
	$FEATURES_ICONSIZE	= $params->get('features_icon_size');
	$SHOW_ICON_TITLE	= $params->get('show_icon_title');

	// Get media path
	$params_media	= JComponentHelper::getParams('com_media');
	$image_path		= $params_media->get('image_path', 'images');

	$layout			= $params->get('layout');

	$time			= $params->get('filter_by_date', 1);

	$datetime_today	= JHtml::date('now', 'Y-m-d H:i');
	$date_today		= JHtml::date('now', 'Y-m-d');

	// Load List
	$i = '';
	$nb = 0;

	// Check if GD is enabled
	if (extension_loaded('gd') && function_exists('gd_info'))
	{
		$thumb_generator = $iCparams->get('thumb_generator', 1);
	}
	else
	{
		$thumb_generator = 0;
	}

	// Get limit Short Description Global Option
	$limitShortDesc = $iCparams->get('ShortDescLimit');

	// Get XSmall thumbnail Settings - Component Options
	$thumb_xsmall			= $iCparams->get('thumb_xsmall', array("48","48","80","1"));
	$thumb_xsmall_width		= is_numeric($thumb_xsmall[0]) ? $thumb_xsmall[0]. 'px' : '';
	$thumb_xsmall_height	= is_numeric($thumb_xsmall[1]) ? $thumb_xsmall[1]. 'px' : '';

	// Check if fopen is allowed
	$fopen = true;
	$result = ini_get('allow_url_fopen');

	if (empty($result))
	{
		$fopen = false;
	}

// Get all dates list from component
$all_dates_with_id	= icagendaEventsData::getAllDates($time, $datesDisplay, $orderby, $mcatid, $params);

$displayed_items = 0;

/*
 * Module Display
 */
echo '<!-- iCagenda PRO - Event List -->';
echo '<div class="ic_eventlist' . $moduleclass_sfx . '">';

// Display Header
if ($header_text)
{
	echo '<div class="ic-header-text">' . $header_text . '</div>';
}

// Start Section
echo '<div class="ic-section ic-group">';

if ($list)
{
	// Set number of events to be displayed per page
	$getpage				= '1'; // Only One. Not yet an ajax pagination for this module (roadmap)
	$index					= $limitcount * ($getpage - 1);
	$recordsToBeDisplayed	= array_slice($all_dates_with_id, $index, $limitcount, true);

	// Do for each dates to be displayed on this list of events, depending of menu and/or global options
	for ($i = 0; $i < count($all_dates_with_id); $i++)
	{
		// Get id and date for each date to be displayed
		$evt_date_id		= $all_dates_with_id[$i];
		$ex_alldates_array	= explode('_', $evt_date_id);
		$evt				= $ex_alldates_array['0'];
		$evt_id				= $ex_alldates_array['1'];

		if (in_array($evt_date_id, $recordsToBeDisplayed))
		{
			foreach ($list as $item)
			{
				if ($evt_id == $item->id
					&& empty($item->approval))
				{
					$evtParams = '';
					$evtParams = new JRegistry($item->params);

					$eventTimeZone  = null;
					$startDate_TZ   = iCDate::isDate($item->startdate)
									? JHtml::date($item->startdate, 'Y-m-d H:i', $eventTimeZone)
									: false;
					$endDate_TZ     = iCDate::isDate($item->enddate)
									? JHtml::date($item->enddate, 'Y-m-d H:i', $eventTimeZone)
									: false;
					$period_array   = iCDatePeriod::listDates($item->startdate, $item->enddate); // UTC
					$only_startdate = ($item->weekdays || $item->weekdays == '0') ? false : true;
					$this_date_utc  = date('Y-m-d H:i', strtotime($evt));


					$eventID		= $item->id;
					$eventTitle		= $item->title;
					$eventCity		= $item->city;
					$eventVenue		= $display_venue ? $item->place : false;

					$nextTime       = icagendaRender::dateToTime($evt);


					// Intro Text
					$description    = $item->desc;
					$limit          = $paramlimit ? $paramlimit_Content : false;
					$shortDesc      = icagendaEvents::shortDescription($description, true, $filtering_shortDesc, $limit);

					$display_shortDesc = true;

					// Short Description
					if ($param_shortDesc == '1')
					{
						$display_shortDesc = true;
						$shortDesc	= $item->shortdesc ? $item->shortdesc : false;
					}

					// Auto-Introtext
					elseif ($param_shortDesc == '2')
					{
						$display_shortDesc = true;
						$shortDesc	= $shortDesc ? $shortDesc : false;
					}

					// Hide
					elseif ($param_shortDesc == '0')
					{
						$display_shortDesc = false;
						$shortDesc	= false;
					}

					// Auto (First Short Description, if does not exist, Auto-generated short description from the full description. And if does not exist, will use meta description if not empty)
					else
					{
						$short_description = $item->shortdesc ? $item->shortdesc : $shortDesc;
						$shortDesc	= $short_description ? $short_description : $item->metadesc;
					}

							$ic_datetime = $ic_date = $ic_time = false;

							if ($display_dateTime == 1)
							{
								$ic_datetime = true;
							}
							elseif ($display_dateTime == 2)
							{
								$ic_date = true;
							}
							elseif ($display_dateTime == 3 && $item->displaytime == 1)
							{
								$ic_time = true;
							}

							/**
							 *	Feature Icons
							 */
							$featureIcons = icagendaEvents::featureIcons($eventID);

							$FEATURES_ICONROOT		= JURI::base() . "$image_path/icagenda/feature_icons/$FEATURES_ICONSIZE/";
							$FEATURES_ICONS			= array();

							if ( isset($featureIcons)
								&& is_array($featureIcons)
								&& (!empty($FEATURES_ICONSIZE)) )
							{
								foreach ($featureIcons as $feature)
								{
									$FEATURES_ICONS[] = array('icon' => $feature->icon, 'icon_alt' => $feature->icon_alt);
								}
							}

						/**
						 *	Set event date and format
						 */

							// If current full period
							if ($only_startdate
								&& in_array($this_date_utc, $period_array)
								&& strtotime($startDate_TZ) < strtotime($datetime_today)
								&& strtotime($endDate_TZ) >= strtotime($datetime_today)
								)
							{
								$evt        = date('Y-m-d H:i');
							}

							// If current full period
							if ($only_startdate
								&& in_array($this_date_utc, $period_array)
								)
							{
								$regDate    = '';
							}
							else
							{
								$regDate    = date('Y-m-d H:i:s', strtotime($evt));
							}

						if (empty($display_regInfos))
						{
							$registered		= false;
							$maxTickets		= false;
							$TicketsLeft	= false;
						}
						else
						{
//							$registered		= $item->registered;
							$typeReg		= $evtParams->get('typeReg', 1);
							$registered		= icagendaRegistration::getRegisteredTotal($item->id, $regDate, $typeReg);
							$get_maxTickets	= $evtParams->get('maxReg', '');

							if ($get_maxTickets < 1)
							{
								$maxTickets		= false;
								$TicketsLeft	= false;
							}
							else
							{
								$maxTickets		= $evtParams->get('maxReg');
								$TicketsLeft	= ($get_maxTickets - $registered);
								$TicketsLeft	= $TicketsLeft > 0 ? $TicketsLeft : '0';
							}
						}


						$urlevent       = '';
						$event_filters  = array(
											'date'      => $evt,
											'catid'     => $item->catid,
											'language'  => $item->language,
											'access'    => $item->access,
										);

						// If use menu item filters
						if ($iCmenu_filters === '1')
						{
							$linkid = $iCmenuitem
									? icagendaMenus::displayEventItemid($iCmenuitem, $event_filters)
									: icagendaMenus::thisEventItemid($evt, $item->catid, $iC_list_menus);
						}
						else
						{
							$linkid = $iCmenuitem ? $iCmenuitem : icagendaMenus::thisEventItemid($evt, $item->catid, $iC_list_menus);
							$linkid = $linkid ? $linkid : $menu->getDefault($lang->getTag())->id;
						}

//							if (is_numeric($iCmenuitem))
//							{
//								$linkid = $iCmenuitem;
//							}
//							else
//							{
//								$linkid = icagendaMenus::thisEventItemid($evt, $item->catid, $iC_list_menus);
//							}

//							$linkid = $linkid ? $linkid : $menu->getDefault($lang->getTag())->id;

						if (is_numeric($linkid))
						{
							$displayed_items    = $displayed_items + 1;

								if ($only_startdate
									&& in_array($this_date_utc, $period_array)
									&& strtotime($startDate_TZ) < strtotime($datetime_today)
									&& strtotime($endDate_TZ) >= strtotime($datetime_today)
									)
								{
									$nextDay	= JHtml::date($datetime_today, 'd', $eventTimeZone);
									$eventDate	= JHtml::date($datetime_today , JText::_('DATE_FORMAT_LC3'), $eventTimeZone);
									$this_date	= JHtml::date($datetime_today , 'Y-m-d', $eventTimeZone);
									$this_time	= JHtml::date($evt, 'H:i', $eventTimeZone);
								}
								elseif ($params->get('filter_by_date', '1') == '4'
									&& (JHtml::date($evt , 'Y-m-d', $eventTimeZone) != JHtml::date('now' , 'Y-m-d'))
									)
								{
									$nextDay	= JHtml::date($datetime_today, 'd', $eventTimeZone);
									$eventDate	= JHtml::date($datetime_today , JText::_('DATE_FORMAT_LC3'), $eventTimeZone);
									$this_date	= JHtml::date($datetime_today , 'Y-m-d', $eventTimeZone);
									$this_time	= JHtml::date($evt, 'H:i', $eventTimeZone);
								}
								else
								{
									$nextDay	= JHtml::date($evt, 'd', $eventTimeZone);
									$eventDate	= JHtml::date($evt , JText::_('DATE_FORMAT_LC3'), $eventTimeZone);
									$this_date	= JHtml::date($evt , 'Y-m-d', $eventTimeZone);
									$this_time	= JHtml::date($evt, 'H:i', $eventTimeZone);
								}

							if ($monthFormat == 1)
							{
								$nextMonth = date('m', strtotime($this_date));
							}
							elseif ($monthFormat == 2)
							{
								// We need month in english to set the translation string.
								$nextMonth = JText::_(date("F", strtotime($this_date)) . '_SHORT');
							}

								$event_slug = $item->alias ? $item->id . ':' . $item->alias : $item->id;

								// Set variable date-alias in url
								if ($only_startdate && in_array($this_date_utc, $period_array))
								{
									$set_date_in_url = '';
								}
								else
								{
									$set_date_in_url = '&amp;date=' . iCDate::dateToAlias($this_date . ' ' . $this_time);
								}

								$urlEvent	= JRoute::_('index.php?option=com_icagenda&amp;view=event&amp;id='
											. $event_slug . '&amp;Itemid=' . (int) $linkid . $set_date_in_url);


							// Style for Layout
							$style = str_replace('_:', '', $layout);

							if (file_exists(__DIR__ . '/css/' . $style . '_style.css'))
							{
								$module_style       = 'modules/mod_ic_event_list/css/' . $style . '_style.css';
								$module_style_rss   = 'modules/mod_ic_event_list/css/' . $style . '_style-rtl.css';

								$document->addStyleSheet( JURI::base() . $module_style );

								// RTL css if site language is RTL
								if ($lang->isRTL()
									&& file_exists(__DIR__ . '/css/' . $style . '_style-rtl.css'))
								{
									$document->addStyleSheet(JURI::base() . $module_style_rss);
								}
							}

							// Set Theme Pack variables
							$EVENT_DATETIME = $DATE = $evt; // Use $EVENT_DATETIME | $DATE kept for not-updated custom layouts
							$EVENT_IMAGE    = $item->image;

							// @TODO: Theme Pack var
							$cat_color      = $item->catcolor;
							$font_color     = modiCEventListHelper::getfontColor($item->catcolor);
							$thumb_img      = modiCEventListHelper::getThumbnail($item->image, $thumb_generator);
							$displayTime    = $item->displaytime;

							/*
							 * B/C for old versions
							 */
							$item->next = $nextDate = $evt; // Use $EVENT_DATETIME | @deprecated 3.6 - @removed 4.0
							$imageSet   = $item->image; // Use $EVENT_IMAGE | @deprecated 3.6 - @removed 4.0
							$catid      = $item->catid; // @deprecated 3.6 - @removed 4.0

							// Load template to display each event in the list
							require (JModuleHelper::getLayoutPath('mod_ic_event_list', $layout));
						}
					}
				}
			}
		}

		$total_items = count($recordsToBeDisplayed);

		if ($displayed_items == '0'
			&& $total_items > 0)
		{
			echo '<div class="ic-msg-no-event">' . JText::_('MOD_IC_EVENT_LIST_ALL_NO_EVENT_TEXT') . '</div>';
		}

		if ($total_items > $displayed_items)
		{
			$not_displayed = ($total_items - $displayed_items);
			$user = JFactory::getUser();

			if ($user->authorise('core.admin'))
			{
				echo '<div class="alert alert-warning">' . JText::sprintf('IC_MODULE_ALERT_EVENTS_NOT_DISPLAYED', $not_displayed) . '</div>';
			}
		}
	}
	else
	{
		if ($time == '4') { $ordertext = 'today'; }
		elseif ($time == '3' || $time == '1') { $ordertext = 'future'; }
		elseif ($time == '2') { $ordertext = 'past'; }
		elseif ($time == '0') { $ordertext = 'all'; }

		echo '<div class="ic-msg-no-event">' . JText::_('MOD_IC_EVENT_LIST_' . strtoupper($ordertext) . '_NO_EVENT_TEXT') . '</div>';
	}

	echo '</div>';

	if ($footer_text)
	{
		echo '<div class="ic-footer-text">' . $footer_text . '</div>';
	}


echo '</div>';
echo '<div style="clear:both"></div>';


// For Dev.
if ($time_loading)
{
	$endtime_cal = iCLibrary::getMicrotime();

	echo '<center style="font-size:8px;">Time to create list: ' . round($endtime_cal - $starttime_cal, 3) . ' seconds</center>';
}
